<?php
require 'config/connection.php'; // Include database connection

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $trader_name = trim($_POST['trader_name']);
    $win_rate = floatval($_POST['win_rate']);
    $profit_percent = floatval($_POST['profit_percent']);

    if (empty($trader_name) || $win_rate <= 0 || $profit_percent <= 0) {
        $message = "Invalid input. Please check your entries.";
        $type = "danger";
    } else {
        // Initialize SQL and bind types for basic trader info
        $sql = "INSERT INTO copy_traders (trader_name, win_rate, profit_percent";
        $types = "sdd";
        $params = [$trader_name, $win_rate, $profit_percent];
        
        // $imagePath = null;
        
        // Handle image upload if a file is provided
        if (isset($_FILES['trader_image']) && $_FILES['trader_image']['error'] === UPLOAD_ERR_OK) {
            $image = $_FILES['trader_image'];
            $imageName = basename($image['name']);
            $targetDir = '../../../assets/copy_trader_images/';
            $targetFile = $targetDir . uniqid() . "_" . $imageName;

            // Validate image type (optional: add size and dimension checks)
            $imageFileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));
            $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];

            if (!in_array($imageFileType, $allowedTypes)) {
                $message = "Only JPG, JPEG, PNG, and GIF files are allowed.";
                $type = "danger";
                header("Location: ../../copy_traders.php?message=" . urlencode($message) . "&type=" . urlencode($type));
                exit();
            }

            if (!move_uploaded_file($image['tmp_name'], $targetFile)) {
                $message = "Failed to upload image.";
                $type = "danger";
                header("Location: ../../copy_traders.php?message=" . urlencode($message) . "&type=" . urlencode($type));
                exit();
            }
            
            // Append to SQL for image
            $sql .= ", trader_image) VALUES (?, ?, ?, ?)";
            $types .= "s";
            $params[] = $targetFile;
        } else {
            $sql .= ") VALUES (?, ?, ?)";
        }

        // Prepare and bind
        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);

        if ($stmt->execute()) {
            $message = "Trader added successfully!";
            $type = "success";
        } else {
            $message = "Error adding trader!";
            $type = "danger";
        }

        $stmt->close();
    }

    $conn->close();

    header("Location: ../../copy_traders.php?message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}