<?php
require 'config/connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate input
    if (
        !isset($_POST['user_id'], $_POST['username'], $_POST['stock'], $_POST['amount'], $_POST['trade_type'], $_POST['result']) ||
        !ctype_digit($_POST['user_id']) ||
        !in_array($_POST['trade_type'], ['buy', 'sell']) ||
        !in_array($_POST['result'], ['win', 'loss']) ||
        !is_numeric($_POST['amount'])
    ) {
        $message = "Invalid request!";
        $type = "error";
        header("Location: ../../edit_user.php?user_id=" . urlencode($user_id) . "&message=" . urlencode($message) . "&type=" . urlencode($type));
        exit();
    }

    $user_id = intval($_POST['user_id']);
    $username = trim($_POST['username']);
    $stock = trim($_POST['stock']);
    $amount = floatval($_POST['amount']);
    $trade_type = $_POST['trade_type'];
    $result = $_POST['result'];

    // Fetch user balance
    $stmt = $conn->prepare("SELECT balance, profit_balance FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result_user = $stmt->get_result();
    $user = $result_user->fetch_assoc();
    $stmt->close();

    if (!$user) {
        $message = "User not found!";
        $type = "error";
        header("Location: ../../edit_user.php?user_id=" . urlencode($user_id) . "&message=" . urlencode($message) . "&type=" . urlencode($type));
        exit();
    }

    if ($user['balance'] < $amount) {
        $message = "Insufficient balance!";
        $type = "error";
        header("Location: ../../edit_user.php?user_id=" . urlencode($user_id) . "&message=" . urlencode($message) . "&type=" . urlencode($type));
        exit();
    }
    
    if ($result === 'win') {
        $inputted_profit = $amount * 2;
        $inputted_result = "Profit";
    } else {
        $inputted_profit = "-" . $amount;
        $inputted_result = "Loss";
    }

    // Insert the trade
    $stmt = $conn->prepare("INSERT INTO live_trading (user_id, stock, amount, trade_type, result, profit, status, created_at) VALUES (?, ?, ?, ?, ?, ?, 'completed', NOW())");
    $stmt->bind_param("isdsss", $user_id, $stock, $amount, $trade_type, $inputted_result, $inputted_profit);

    if ($stmt->execute()) {
        $stmt->close();

        if ($result === 'win') {
            $profit = $amount * 2;

            $stmt = $conn->prepare("UPDATE users SET balance = balance - ?, profit_balance = profit_balance + ? WHERE id = ?");
            $stmt->bind_param("ddi", $amount, $profit, $user_id);
        } else {
            $stmt = $conn->prepare("UPDATE users SET balance = balance - ? WHERE id = ?");
            $stmt->bind_param("di", $amount, $user_id);
        }

        if ($stmt->execute()) {
            $message = "Trade generated successfully.";
            $type = "success";
        } else {
            $message = "Trade created, but failed to update balance.";
            $type = "error";
        }
        $stmt->close();
    } else {
        $message = "Failed to create trade.";
        $type = "error";
        $stmt->close();
    }

    $conn->close();

    header("Location: ../../edit_user.php?user_id=" . urlencode($user_id) . "&message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}
?>
 