<?php
// require 'config/connection.php';

// if ($_SERVER["REQUEST_METHOD"] == "POST") {
//     $user_id = $_POST['user_id'];

//     // Sanitize inputs
//     $wallets = [
//         'btc_wallet'  => $_POST['btc_wallet'],
//         'eth_wallet'  => $_POST['eth_wallet'],
//         'usdt_wallet' => $_POST['usdt_wallet'],
//         'bnb_wallet'  => $_POST['bnb_wallet'],
//         'ltc_wallet'  => $_POST['ltc_wallet'],
//         'doge_wallet' => $_POST['doge_wallet'],
//         'xrp_wallet'  => $_POST['xrp_wallet'],
//         'shib_wallet' => $_POST['shib_wallet'],
//         'sol_wallet'  => $_POST['sol_wallet'],
//     ];

//     // Prepare statement
//     $stmt = $conn->prepare("UPDATE admin SET btc=?, eth=?, usdt=?, bch=?, ltc=?, doge=?, xrp=?, shib=?, sol=? WHERE id=?");
//     $stmt->bind_param(
//         "sssssssssi",
//         $wallets['btc_wallet'],
//         $wallets['eth_wallet'],
//         $wallets['usdt_wallet'],
//         $wallets['bnb_wallet'],
//         $wallets['ltc_wallet'],
//         $wallets['doge_wallet'],
//         $wallets['xrp_wallet'],
//         $wallets['shib_wallet'],
//         $wallets['sol_wallet'],
//         $user_id
//     );

//     // Execute and check result
//     if ($stmt->execute()) {
//         $message = "Wallet Addresses Updated Successfully!";
//         $type = "success";
//     } else {
//         $message = "Error Updating Wallet Addresses!";
//         $type = "error";
//     }

//     $stmt->close();
//     $conn->close();

//     // Redirect back with message
//     header("Location: ../../dashboard.php?message=" . urlencode($message) . "&type=" . urlencode($type));
//     exit();
// }
require 'config/connection.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $user_id = $_POST['user_id'];
    $coins = ['btc', 'eth', 'usdt', 'bch', 'ltc', 'doge', 'xrp', 'shib', 'sol'];

    $wallets = [];
    $images = [];
    
    $stmt = $conn->prepare("SELECT * FROM admin WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $current_data = $result->fetch_assoc();
    $stmt->close();

    // Handle wallet values and image uploads
    foreach ($coins as $coin) {
        $wallet_field = $coin . '_wallet';
        $image_field = $coin . '_pic';

        $wallets[$coin] = $_POST[$wallet_field];

        if (isset($_FILES[$image_field]) && $_FILES[$image_field]['error'] === UPLOAD_ERR_OK) {
            $filename = time() . "_" . basename($_FILES[$image_field]['name']);
            $target = "../../../user/assets/uploads/" . $filename;
            move_uploaded_file($_FILES[$image_field]['tmp_name'], $target);
            $images[$coin . '_pic'] = $filename;
        } else {
            // Use existing image if no new upload
            $images[$coin . '_pic'] = $current_data[$coin . '_pic'] ?? null;
        }
    }

    // Prepare dynamic SQL
    $sql = "UPDATE admin SET 
        btc=?, btc_pic=?,
        eth=?, eth_pic=?,
        usdt=?, usdt_pic=?,
        bch=?, bch_pic=?,
        ltc=?, ltc_pic=?,
        doge=?, doge_pic=?,
        xrp=?, xrp_pic=?,
        shib=?, shib_pic=?,
        sol=?, sol_pic=?
        WHERE id=?";

    $stmt = $conn->prepare($sql);

    $stmt->bind_param(
        "ssssssssssssssssssi",
        $wallets['btc'], $images['btc_pic'],
        $wallets['eth'], $images['eth_pic'],
        $wallets['usdt'], $images['usdt_pic'],
        $wallets['bch'], $images['bch_pic'],
        $wallets['ltc'], $images['ltc_pic'],
        $wallets['doge'], $images['doge_pic'],
        $wallets['xrp'], $images['xrp_pic'],
        $wallets['shib'], $images['shib_pic'],
        $wallets['sol'], $images['sol_pic'],
        $user_id
    );

    if ($stmt->execute()) {
        $message = "Wallet Info Updated Successfully!";
        $type = "success";
    } else {
        $message = "Error updating wallet info!";
        $type = "error";
    }

    $stmt->close();
    $conn->close();

    header("Location: ../../dashboard.php?message=" . urlencode($message) . "&type=" . urlencode($type));
    exit();
}
