<?php
include "../../../assets/php/connection.php";
require_once "../../../admin/assets/php/send_email.php";

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->begin_transaction();

// Function to sanitize input
function cleanInput($data)
{
    return htmlspecialchars(strip_tags(trim($data)));
}

$countryCurrencyMap = [
    'Albania' => 'Lek',
    'Algeria' => 'دج',
    'American Samoa' => '$',
    'Andorra' => '€',
    'Angola' => 'Kz',
    'Anguilla' => '$',
    'Antarctica' => '$',
    'Antigua and Barbuda' => '$',
    'Argentina' => '$',
    'Armenia' => '֏',
    'Aruba' => 'ƒ',
    'Australia' => '$',
    'Austria' => '€',
    'Azerbaijan' => 'AZN',
    'Bahamas' => '$',
    'Bahrain' => 'د.',
    'Bangladesh' => 'ó',
    'Barbados' => '$',
    'Belarus' => 'Br',
    'Belgium' => '€',
    'Belize' => '$',
    'Benin' => 'CFA',
    'Bermuda' => '$',
    'Bhutan' => 'Nu',
    'Bolivia' => 'Bs',
    'Bosnia and Herzegovina' => 'KM',
    "Botswana" => "P",
    "Bouvet Island" => "kr",
    "Brazil" => "R$",
    "British Indian Ocean Territory" => "$",
    "Brunei Darussalam" => "B$",
    "Bulgaria" => "Лв.",
    "Burkina Faso" => "CFA",
    "Burundi" => "FBu",
    "Cambodia" => "៛",
    "Cameroon" => "FCFA",
    "Canada" => "$",
    "Cape Verde" => "$",
    "Cayman Islands" => "$",
    "Central African Republic" => "FCFA",
    "Chad" => "FCFA",
    "Chile" => "$",
    "China" => "¥",
    "Christmas Island" => "$",
    "Cocos (Keeling) Islands" => "$",
    "Colombia" => "$",
    "Comoros" => "CF",
    "Congo" => "FC",
    "Democratic Republic of the Congo" => "FC",
    "Cook Islands" => "$",
    "Costa Rica" => "₡",
    "Cote D'Ivoire" => "CFA",
    "Croatia" => "Kn",
    "Cuba" => "$",
    "Cyprus" => "€",
    "Czech Republic" => "Kč",
    "Denmark" => "kr",
    "Djibouti" => "Fdj",
    "Dominica" => "$",
    "Dominican Republic" => "RD$",
    "Ecuador" => "S/.",
    "Egypt" => "E£",
    "El Salvador" => "₡",
    "Equatorial Guinea" => "FCFA",
    "Eritrea" => "Nkf",
    "Estonia" => "kr",
    "Ethiopia" => "Br",
    "Falkland Islands (Malvinas)" => "£",
    "Faroe Islands" => "kr",
    "Fiji" => "FJ$",
    "Finland" => "mk",
    "France" => "€",
    "French Guiana" => "€",
    "French Polynesia" => "₣",
    "French Southern Territories" => "€",
    "Gabon" => "FCFA",
    "Gambia" => "D",
    "Georgia" => "GEL",
    "Germany" => "€",
    "Ghana" => "GH₵",
    "Gibraltar" => "£",
    "Greece" => "€",
    "Greenland" => "Kr.",
    "Grenada" => "$",
    "Guadeloupe" => "€",
    "Guam" => "$",
    "Guatemala" => "Q",
    "Guernsey" => "£",
    "Guinea" => "FG",
    "Guinea-Bissau" => "CFA",
    "Guyana" => "G$",
    "Haiti" => "G",
    "Heard Island and McDonald Islands" => "$",
    "Holy See (Vatican City State)" => "₤",
    "Honduras" => "HNL",
    "Hong Kong" => "HK$",
    "Hungary" => "Ft",
    "Iceland" => "kr",
    "India" => "₹",
    "Indonesia" => "Rp",
    "Islamic Republic of Iran" => "IRR",
    "Iraq" => "د.ع",
    "Ireland" => "€",
    "Isle of Man" => "£",
    "Israel" => "₪",
    "Italy" => "€",
    "Jamaica" => "J$",
    "Japan" => "¥",
    "Jersey" => "£",
    "Jordan" => "د.ا",
    "Kazakhstan" => "₸",
    "Kenya" => "KSh",
    "Kiribati" => "$",
    "Democratic People's Republic of Korea" => "₩",
    "Republic of Korea" => "₩",
    "Kuwait" => "د.ك",
    "Kyrgyzstan" => "лв",
    "Lao People's Democratic Republic" => "₭",
    "Latvia" => "LVL",
    "Lebanon" => "ل.ل",
    "Lesotho" => "L",
    "Liberia" => "L$",
    "Libyan Arab Jamahiriya" => "LD",
    "Liechtenstein" => "CHF",
    "Lithuania" => "Lt",
    "Luxembourg" => "€",
    "Macao" => "MOP$",
    "The Former Yugoslav Republic of Macedonia" => "den",
    "Madagascar" => "Ar",
    "Malawi" => "K",
    "Malaysia" => "RM",
    "Maldives" => "Rf",
    "Mali" => "MAF",
    "Malta" => "€",
    "Marshall Islands" => "$",
    "Martinique" => "€",
    "Mauritania" => "MRU",
    "Mauritius" => "₨",
    "Mayotte" => "€",
    "Mexico" => "$",
    "Federated States of Micronesia" => "$",
    "Republic of Moldova" => "L",
    "Monaco" => "€",
    "Mongolia" => "₮",
    "Montenegro" => "€",
    "Montserrat" => "$",
    "Morocco" => "MAD",
    "Mozambique" => "MT",
    "Myanmar" => "K",
    "Namibia" => "N$",
    "Nauru" => "$",
    "Nepal" => "Rs",
    "Netherlands" => "ANG",
    "Netherlands Antilles" => "NAf",
    "New Caledonia" => "₣",
    "New Zealand" => "$",
    "Nicaragua" => "C$",
    "Niger" => "XOF",
    "Nigeria" => "₦",
    "Niue" => "$",
    "Norfolk Island" => "$",
    "Northern Mariana Islands" => "$",
    "Norway" => "kr",
    "Oman" => "ر.ع.",
    "Pakistan" => "₨",
    "Palau" => "$",
    "Occupied Palestinian Territory" => "$",
    "Panama" => "B/",
    "Papua New Guinea" => "K",
    "Paraguay" => "₲",
    "Peru" => "S/",
    "Philippines" => "₱",
    "Pitcairn" => "$",
    "Poland" => "zł",
    "Portugal" => "€",
    "Puerto Rico" => "$",
    "Qatar" => "QR",
    "Reunion" => "€",
    "Romania" => "lei",
    "Russian Federation" => "₽",
    "Rwanda" => "FRw",
    "Saint Barthélemy" => "€",
    "Saint Helena" => "£",
    "Saint Kitts and Nevis" => "$",
    "Saint Lucia" => "$",
    "Saint Martin" => "ƒ",
    "Saint Pierre and Miquelon" => "€",
    "Saint Vincent and the Grenadines" => "X$",
    "Samoa" => "$",
    "San Marino" => "€",
    "Sao Tome and Principe" => "Db",
    "Saudi Arabia" => "﷼",
    "Senegal" => "CFA",
    "Serbia" => "din",
    "Seychelles" => "SCR",
    "Sierra Leone" => "Le",
    "Singapore" => "S$",
    "Slovakia" => "SKK",
    "Slovenia" => "€",
    "Solomon Islands" => "Si$",
    "Somalia" => "Sh.so.",
    "South Africa" => "R",
    "South Georgia and the South Sandwich Islands" => "£",
    "Spain" => "€",
    "Sri Lanka" => "Rs",
    "Sudan" => "£SD",
    "Suriname" => "$",
    "Svalbard and Jan Mayen" => "kr",
    "Swaziland" => "L",
    "Sweden" => "kr",
    "Switzerland" => "CHf",
    "Syrian Arab Republic" => "LS",
    "Taiwan, Province Of China" => "NT$",
    "Tajikistan" => "SM",
    "United Republic of Tanzania" => "TSh",
    "Thailand" => "฿)",
    "Timor-Leste" => "$",
    "Togo" => "CFA",
    "Tokelau" => "$",
    "Tonga" => "T$",
    "Trinidad and Tobago" => "TT$",
    "Tunisia" => "د.ت",
    "Turkey" => "₺",
    "Turkmenistan" => "T",
    "Turks and Caicos Islands" => "$",
    "Tuvalu" => "$",
    "Uganda" => "USh",
    "Ukraine" => "₴",
    "United Arab Emirates" => "د.إ",
    "United Kingdom" => "£",
    "United States" => "$",
    "United States Minor Outlying Islands" => "$",
    "Uruguay" => "$",
    "Uzbekistan" => "лв",
    "Vanuatu" => "VT",
    "Venezuela" => "Bs.",
    "Vietnam" => "₫",
    "British, Virgin Islands" => "$",
    "U.S., Virgin Islands" => "$",
    "Wallis And Futuna" => "Fr",
    "Western Sahara" => "د.م.",
    "Yemen" => "﷼",
    "Zambia" => "ZK",
    "Zimbabwe" => "Z$"
];


// Retrieve and validate form data
$fullname = isset($_POST['fullname']) ? cleanInput($_POST['fullname']) : null;
$username = isset($_POST['username']) ? cleanInput($_POST['username']) : null;
$home_address = isset($_POST['home_address']) ? cleanInput($_POST['home_address']) : null;
$city = isset($_POST['city']) ? cleanInput($_POST['city']) : null;
$postal_code = isset($_POST['postal_code']) ? cleanInput($_POST['postal_code']) : null;
$country = isset($_POST['country']) ? cleanInput($_POST['country']) : null;
// $currency = isset($_POST['currency']) ? cleanInput($_POST['currency']) : 'USD';
$phone = isset($_POST['phone']) ? cleanInput($_POST['phone']) : null;
$email = isset($_POST['email']) ? filter_var($_POST['email'], FILTER_VALIDATE_EMAIL) : null;
$password = $_POST['password'];



// Validate required fields
if (!$fullname || !$username || !$phone || !$email || !$password) {
    header("Location: ../../register.php?message=" . urlencode("All required fields must be filled!") . "&message_type=danger");
    exit();
}

if (!array_key_exists($country, $countryCurrencyMap)) {
    header("Location: ../../register.php?message=" . urlencode("Invalid country selected!") . "&message_type=danger");
    exit();
}
$currency = $countryCurrencyMap[$country];

// Check if username, email, or phone already exists
$checkUserSql = "SELECT COUNT(*) AS count FROM users WHERE username = ? OR email = ?";
$stmt = $conn->prepare($checkUserSql);
$stmt->bind_param('ss', $username, $email);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if ($row['count'] > 0) {
    header("Location: ../../register.php?message=" . urlencode("Username or email already in use!") . "&message_type=danger");
    exit();
}

// Hash the password securely
$password_hash = password_hash($password, PASSWORD_DEFAULT);

// Insert data into database
$insertSql = "INSERT INTO users (fullname, username, home_address, city, postal_code, country, currency, phone, email, password_hash, password) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($insertSql);
$stmt->bind_param('sssssssssss', $fullname, $username, $home_address, $city, $postal_code, $country, $currency, $phone, $email, $password_hash, $password);

// Prepare email details
$subject = "Welcome to Our Platform!";
$message = '
<!DOCTYPE html>
<html>
<head>
    <title>Welcome to Our Platform</title>
    <style>
        @import url(\'https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap\');
        
        body {
            font-family: \'Poppins\', Arial, sans-serif;
            line-height: 1.6;
            color: #333333;
            margin: 0;
            padding: 20px;
            background-color: #f0f0f0 !important;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        .email-wrapper {
            background-color: #f0f0f0;
            padding: 20px;
        }
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .header {
            text-align: center;
            padding: 30px 20px 20px;
            background-color: #708090;
            border-bottom: 1px solid #eeeeee;
        }
        .logo {
            max-width: 180px;
            height: auto;
            margin-bottom: 20px;
        }
        .content {
            padding: 30px;
            background-color: #ffffff;
        }
        h1 {
            color: #2c3e50;
            font-size: 24px;
            font-weight: 600;
            margin-top: 0;
            margin-bottom: 20px;
        }
        p {
            margin-bottom: 20px;
            font-size: 15px;
            color: #555555;
        }
        ul {
            margin-bottom: 20px;
            padding-left: 20px;
        }
        li {
            margin-bottom: 10px;
            font-size: 15px;
            color: #555555;
        }
        strong {
            color: #2c3e50;
            font-weight: 500;
        }
        .footer {
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #777777;
            background-color: #708090;
            border-top: 1px solid #eeeeee;
        }
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                border-radius: 0 !important;
            }
            .content {
                padding: 20px !important;
            }
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="email-container">
            <div class="header">
                <img src="https://bitpromarketprime.live/auth/assets/images/logo.png" class="logo" alt="Bitpro Market Prime Logo" width="180">
                <h1>Hi '.htmlspecialchars($fullname).',</h1>
            </div>
            
            <div class="content">
                <p>Welcome to our platform! Below are your account details:</p>
                
                <ul>
                    <li><strong>Username:</strong> '.htmlspecialchars($username).'</li>
                    <li><strong>Email:</strong> '.htmlspecialchars($email).'</li>
                    <li><strong>Phone:</strong> '.htmlspecialchars($phone).'</li>
                </ul>
                
                <p>Please keep your credentials safe. If you have any questions, feel free to reach out to our support team.</p>
                
                <p>Best regards,<br><strong>The Support Team</strong></p>
            </div>
            
            <div class="footer">
                <p>&copy; '.date('Y').' Bitpro Market Prime. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
</html>
';

try {
    if (!$stmt->execute()) {
        throw new Exception("Database insertion failed: " . $stmt->error);
    }

    // Send welcome email
    // $email_status = sendNotificationEmail($email, $message, $subject);
    // if ($email_status !== true) {
    //     throw new Exception("Email sending failed: " . $email_status);
    // }
    
    if (!sendNotificationEmail($email, $message, $subject)) {
        throw new Exception("Failed to send email notification!");
    }

    // Commit transaction
    $conn->commit();

    // Redirect with success message
    $user_message = "Registration successful. Please check your email for confirmation.";
    header("Location: ../../login.php?message=" . urlencode($user_message) . "&message_type=success");
    exit();
} catch (Exception $e) {
    // Rollback transaction if an error occurs
    $conn->rollback();

    // Redirect with error message
    $error_message = "Something went wrong, try again.";
    header("Location: ../../register.php?message=" . urlencode($e->getMessage()) . "&message_type=danger");
    exit();
} finally {
    $stmt->close();
    $conn->close();
}
