<?php
include "../../../assets/php/connection.php";

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Sanitize input
function cleanInput($data)
{
    return htmlspecialchars(stripslashes(trim($data)));
}

// Retrieve and validate deposit data
$method = isset($_POST['paymentmethod']) ? cleanInput($_POST['paymentmethod']) : null;
$user_id = isset($_POST['user_id']) ? cleanInput($_POST['user_id']) : null;
$username = isset($_POST['username']) ? cleanInput($_POST['username']) : null;
$amount = isset($_POST['amount']) ? cleanInput($_POST['amount']) : null;
// $wallet_address = isset($_POST['wallet-address']) ? cleanInput($_POST['wallet-address']) : null;
$transaction_type = "deposit"; // Only deposit in this version

// Validate required fields
if (!$method || !$user_id || !$username || !$amount) {
    header("Location: ../../deposit.php?message=" . urlencode("All required fields must be filled!") . "&message_type=danger");
    exit();
}

// File Upload Handling (required for deposit)
$upload_dir = '../uploads/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

function uploadFile($file, $upload_dir, $prefix)
{
    $filename = $prefix . '_' . time() . '_' . basename($file['name']);
    $target_file = $upload_dir . $filename;

    // Validate file type
    $allowed_types = ['image/jpeg', 'image/png', 'image/jpg'];
    if (!in_array($file['type'], $allowed_types)) {
        return false;
    }

    if (move_uploaded_file($file['tmp_name'], $target_file)) {
        return $filename;
    }
    return false;
}

// Check if image is provided
if (!isset($_FILES['requestProof']) || $_FILES['requestProof']['error'] !== UPLOAD_ERR_OK) {
    header("Location: ../../deposit.php?message=" . urlencode("Deposit screenshot is required!") . "&message_type=danger");
    exit();
}

$selfie = uploadFile($_FILES['requestProof'], $upload_dir, 'deposit');
if (!$selfie) {
    header("Location: ../../deposit.php?message=" . urlencode("Invalid image format! Only JPG and PNG allowed.") . "&message_type=danger");
    exit();
}

// Insert deposit into the database
$insert_query = "INSERT INTO transactions (user_id, username, transaction_type, method, amount, request_image, status) VALUES (?, ?, ?, ?, ?, ?, 'pending')";
$stmt = $conn->prepare($insert_query);
$stmt->bind_param("isssds", $user_id, $username, $transaction_type, $method, $amount, $selfie);

if ($stmt->execute()) {
    header("Location: ../../deposit.php?message=" . urlencode("Deposit submitted successfully.") . "&message_type=success");
} else {
    header("Location: ../../deposit.php?message=" . urlencode("Database error. Try again.") . "&message_type=danger");
}

$stmt->close();
$conn->close();
