<?php
session_start();

include "assets/php/connection.php";

if (!isset($_SESSION['user_id'])) {
    session_unset();
    session_destroy();
    header("Location: ../auth/login.php");
    exit();
}

// Get user_id from the session
$user_id = $_SESSION['user_id'] ?? 0;

// Fetch user details from the database
$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
} else {
    // If no user is found, redirect to login page
    session_unset();
    session_destroy();
    header("Location: ../auth/login.php?message=" . urlencode("No user found!") . "&message_type=danger");
    exit();
}

// Get the current script name  (page being accessed)
$current_page = basename($_SERVER['PHP_SELF']);

// 🚫 Restrict unverified users (verified == 0) to ONLY dashboard.php & kyc-verification.php
if ($user['verified'] == 0 && !in_array($current_page, ["dashboard.php", "verify.php", "logout.php"])) {
    header("Location: verify.php?message=" . urlencode("Please complete KYC verification.") . "&message_type=warning");
    exit();
}

// 🚫 Prevent verified users (verified == 1) from accessing kyc-verification.php
if ($user['verified'] == 1 && $current_page == "verify.php") {
    header("Location: dashboard.php?message=" . urlencode("Your account is already verified!") . "&message_type=success");
    exit();
}

// 🚨 Restrict users from accessing live_trading.php if lock_trading == 1
if ($user['lock_trading'] == 1 && $current_page == "live_trading.php") {
    header("Location: dashboard.php?message=" . urlencode("Trading is locked on your account.") . "&message_type=danger");
    exit();
}

// 🚨 Restrict users from accessing traders.php if lock_copy_traders == 1
if ($user['lock_copy_traders'] == 1 && $current_page == "traders.php") {
    header("Location: dashboard.php?message=" . urlencode("Copy trading is locked on your account.") . "&message_type=danger");
    exit();
}