<?php
include "config.php";

// Fetch all live sessions for the user
$query = "SELECT * FROM live_trading_v2 WHERE user_id = ? AND session = 'live'";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$sessions = [];
while ($row = $result->fetch_assoc()) {
    $sessions[] = $row;
}

$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Live Trading</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" integrity="sha512-rt/SrQ4UNIaGfDyEXZtNcyWvQeOq0QLygHluFQcSjaGB04IxWhal71tKuzP6K8eYXYB6vJV4pHkXcmFGGQ1/0w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" type="text/css" href="assets/css/css2.css">
    <link rel="stylesheet" type="text/css" href="assets/css/deposit.css">
    <link rel="stylesheet" type="text/css" href="assets/css/css.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard.css">
    <link rel="stylesheet" type="text/css" href="assets/css/sidebar.css">

    <style>
        body {
            font-family: 'Roboto' !important;
        }

        .trade-form {
            max-width: 500px;
            margin: 20px auto;
            padding: 20px;
            background: #1e1e1e;
            color: #fff;
            border-radius: 8px;
        }

        .submit-btn {
            background-color: #22b21f;
            border: none;
            padding: 10px;
            color: white;
            cursor: pointer;
        }

        .submit-btn:hover {
            background-color: #1a9518;
        }

        .modal-content {
            background-color: #1e1e1e;
            color: #fff;
        }

        #countdown {
            font-size: 24px;
            font-weight: bold;
            color: #ffcc00;
        }
    </style>
    
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body style="background-size:cover;
            background-position:center;
            background:url('assets/images/mask_group.svg');background-color:#000;">

    <section class="">
        <div class="justify-content-between" style="margin-top:-35px;">
            <link rel="stylesheet" href="assets/css/notify.css">
            <link rel="stylesheet" href="assets/css/custom.css">

            <div class="content">
                <div class="ddown">
                    <div class="linklist">
                        <a href="profile.php">Profile</a>
                    </div>
                    <a href="logout.php">
                        <div class="logout">logout </div>
                    </a>
                </div>

				<div class="top">
					<div class="menu2" id="menu">
					</div>

					<div class="top-m">
						<div><?= $user["username"] ?></div>
						<div class="verified"></div>
					</div>

					<div class="right">
						<div class="nameicon" id="nameicon" data-name="Trojan">
							<div id="name">
								<span><?= strtoupper(substr($user["username"], 0, 1)) ?></span>
							</div>
						</div>
					</div>
				</div>

                <div class="sidebar" id="sidebar" style="background-color:#141414;">
                    <div class="logo">
                        <img src="assets/images/logo.svg" width="150px">
                    </div>

                    <div class="chil">
                        <div class="linklist">

                            <a href="dashboard.php" data-highlight="url">
                                <img src="assets/images/p.svg">
                                <div class="title">Portfolio
                                </div>
                            </a>

                            <a href="deposit.php" data-highlight="url">
                                <img src="assets/images/d.svg">
                                <div class="title">Deposit
                                </div>
                            </a>

                            <a href="withdrawal.php" data-highlight="url">
                                <img src="assets/images/w.svg">
                                <div class="title">Withdraw
                                </div>
                            </a>

                            <a href="live-trading.php" data-highlight="url">
                                <img src="assets/images/t.svg">
                                <div class="title">Trades
                                </div>
                            </a>

                            <a href="account-upgrade.php" data-highlight="url">
                                <img src="assets/images/s.svg">
                                <div class="title">Subscription
                                </div>
                            </a>

                            <a href="trading-stock.php" data-highlight="url">
                                <img src="assets/images/sk.svg">
                                <div class="title">Stocks
                                </div>
                            </a>

                            <a href="signal-package.php" data-highlight="url">
                                <img src="assets/images/sg.svg">
                                <div class="title">Signal
                                </div>
                            </a>

                            <a href="traders.php" data-highlight="url">
                                <img src="assets/images/c.svg">
                                <div class="title">Copy Experts
                                </div>
                            </a>

                            <a href="transactions.php" data-highlight="url">
                                <img src="assets/images/assets.svg">
                                <div class="title">Transactions
                                </div>
                            </a>
                            
							<a href="trades.php" data-highlight="url">
								<img src="assets/images/assets.svg">
								<div class="title">Trades
								</div>
							</a>
                            
                            <?php if ($user['verified'] == 0) : ?>
                                <a href="verify.php" data-highlight="url">
                                    <img src="assets/images/verify.svg" alt="Verify Account">
                                    <div class="title">Verify Account</div>
                                </a>
                            <?php endif; ?>

                            <a href="logout.php" data-highlight="url">
                                <img src="assets/images/logout.svg">
                                <div class="title">Logout
                                </div>
                            </a>

                        </div>
                    </div>

                    <div class="tail" style="margin-top:-75px;">
                        <div class="drip">
                            <div class="img">
                                <img src="assets/images/pers.svg">
                            </div>
                            <div class="tailr">
                                <div class="tailr1"><?= $user["username"] ?></div>
                                <div class="tailr1"><?= $user["account_type"] ?></div>
                            </div>
                        </div>
                    </div>

                </div>

                <!--<div style="margin-top:12px;">-->
                <!--    <p align="center"><strong>PLACE A TRADE</strong></p>-->
                <!--</div>-->

                <!--<div class="amount-card">-->
                <!--    <form id="trade-form" class="trade-form">-->
                <!--        <label>Select Stock:</label>-->
                <!--        <select class="form-control" id="stock" required>-->
                            
                <!--            <option value="BTC/USD" style="color: #000;">Bitcoin (BTC/USD)</option>-->
                <!--            <option value="ETH/USD" style="color: #000;">Ethereum (ETH/USD)</option>-->
                <!--            <option value="LTC/USD" style="color: #000;">Litecoin (LTC/USD)</option>-->
                <!--            <option value="XRP/USD" style="color: #000;">Ripple (XRP/USD)</option>-->
                <!--            <option value="BCH/USD" style="color: #000;">Bitcoin Cash (BCH/USD)</option>-->
                <!--            <option value="EOS/USD" style="color: #000;">EOS (EOS/USD)</option>-->
                <!--            <option value="XLM/USD" style="color: #000;">Stellar (XLM/USD)</option>-->
                <!--            <option value="ADA/USD" style="color: #000;">Cardano (ADA/USD)</option>-->
                <!--            <option value="TRX/USD" style="color: #000;">TRON (TRX/USD)</option>-->
                <!--            <option value="XMR/USD" style="color: #000;">Monero (XMR/USD)</option>-->
                <!--            <option value="NEO/USD" style="color: #000;">NEO (NEO/USD)</option>-->
                <!--            <option value="DASH/USD" style="color: #000;">Dash (DASH/USD)</option>-->
                <!--            <option value="ETC/USD" style="color: #000;">Ethereum Classic (ETC/USD)</option>-->
                <!--            <option value="ZEC/USD" style="color: #000;">Zcash (ZEC/USD)</option>-->
                <!--            <option value="XEM/USD" style="color: #000;">NEM (XEM/USD)</option>-->
                <!--            <option value="ONT/USD" style="color: #000;">Ontology (ONT/USD)</option>-->
                <!--            <option value="IOTA/USD" style="color: #000;">IOTA (IOTA/USD)</option>-->
                <!--            <option value="VET/USD" style="color: #000;">VeChain (VET/USD)</option>-->
                <!--            <option value="BAT/USD" style="color: #000;">Basic Attention Token (BAT/USD)</option>-->
                <!--            <option value="LINK/USD" style="color: #000;">Chainlink (LINK/USD)</option>-->
                <!--            <option value="XTZ/USD" style="color: #000;">Tezos (XTZ/USD)</option>-->
                <!--            <option value="ALGO/USD" style="color: #000;">Algorand (ALGO/USD)</option>-->
                <!--            <option value="AAPL" style="color: #000;">Apple (AAPL)</option>-->
                <!--            <option value="GOOGL" style="color: #000;">Google (GOOGL)</option>-->
                <!--            <option value="TSLA" style="color: #000;">Tesla (TSLA)</option>-->
                <!--            <option value="AMZN" style="color: #000;">Amazon (AMZN)</option>-->
                <!--            <option value="MSFT" style="color: #000;">Microsoft (MSFT)</option>-->
                <!--            <option value="FB" style="color: #000;">Facebook (FB)</option>-->
                <!--            <option value="NFLX" style="color: #000;">Netflix (NFLX)</option>-->
                <!--            <option value="NVDA" style="color: #000;">NVIDIA (NVDA)</option>-->
                <!--            <option value="PYPL" style="color: #000;">PayPal (PYPL)</option>-->
                <!--            <option value="ADBE" style="color: #000;">Adobe (ADBE)</option>-->
                            <!-- Currency Pairs -->
                <!--            <option value="EUR/USD" style="color: #000;">Euro/US Dollar (EUR/USD)</option>-->
                <!--            <option value="GBP/USD" style="color: #000;">British Pound/US Dollar (GBP/USD)</option>-->
                <!--            <option value="USD/JPY" style="color: #000;">US Dollar/Japanese Yen (USD/JPY)</option>-->
                <!--            <option value="USD/CHF" style="color: #000;">US Dollar/Swiss Franc (USD/CHF)</option>-->
                <!--            <option value="AUD/USD" style="color: #000;">Australian Dollar/US Dollar (AUD/USD)</option>-->
                <!--            <option value="NZD/USD" style="color: #000;">New Zealand Dollar/US Dollar (NZD/USD)</option>-->
                <!--            <option value="USD/CAD" style="color: #000;">US Dollar/Canadian Dollar (USD/CAD)</option>-->
                <!--            <option value="EUR/GBP" style="color: #000;">Euro/British Pound (EUR/GBP)</option>-->
                <!--            <option value="EUR/JPY" style="color: #000;">Euro/Japanese Yen (EUR/JPY)</option>-->
                <!--            <option value="GBP/JPY" style="color: #000;">British Pound/Japanese Yen (GBP/JPY)</option>-->
                            <!-- Commodities -->
                <!--            <option value="GOLD" style="color: #000;">Gold (XAU/USD)</option>-->
                <!--            <option value="SILVER" style="color: #000;">Silver (XAG/USD)</option>-->
                <!--            <option value="OIL" style="color: #000;">Crude Oil (WTI)</option>-->
                <!--            <option value="NATGAS" style="color: #000;">Natural Gas</option>-->
                <!--            <option value="COPPER" style="color: #000;">Copper</option>-->
                <!--            <option value="PLATINUM" style="color: #000;">Platinum</option>-->
                <!--            <option value="PALLADIUM" style="color: #000;">Palladium</option>-->
                <!--            <option value="COFFEE" style="color: #000;">Coffee</option>-->
                <!--            <option value="SUGAR" style="color: #000;">Sugar</option>-->
                <!--            <option value="COCOA" style="color: #000;">Cocoa</option>-->
                            <!-- Indices -->
                <!--            <option value="SP500" style="color: #000;">S&P 500 (SP500)</option>-->
                <!--            <option value="NASDAQ" style="color: #000;">NASDAQ Composite (NASDAQ)</option>-->
                <!--            <option value="DOW" style="color: #000;">Dow Jones Industrial Average (DOW)</option>-->
                <!--            <option value="FTSE100" style="color: #000;">FTSE 100 (FTSE100)</option>-->
                <!--            <option value="DAX" style="color: #000;">DAX (DAX)</option>-->
                <!--            <option value="CAC40" style="color: #000;">CAC 40 (CAC40)</option>-->
                <!--            <option value="NIKKEI225" style="color: #000;">Nikkei 225 (NIKKEI225)</option>-->
                <!--            <option value="HANGSENG" style="color: #000;">Hang Seng (HANGSENG)</option>-->
                <!--            <option value="ASX200" style="color: #000;">ASX 200 (ASX200)</option>-->
                <!--            <option value="Bovespa" style="color: #000;">Bovespa (Bovespa)</option>-->
                <!--        </select>-->

                <!--        <label>Trade Type:</label>-->
                <!--        <select class="form-control" id="trade-type" required>-->
                <!--            <option value="BUY" style="color: #000;">Buy</option>-->
                <!--            <option value="SELL" style="color: #000;">Sell</option>-->
                <!--        </select>-->

                <!--        <label>Trade Amount ($):</label>-->
                <!--        <input type="number" id="amount" class="form-control" placeholder="Enter amount" required>-->

                <!--        <label>Duration:</label>-->
                <!--        <select class="form-control" id="duration" required>-->
                <!--            <option value="30" style="color: #000;">30 Seconds</option>-->
                <!--            <option value="60" style="color: #000;">1 Minute</option>-->
                <!--            <option value="300" style="color: #000;">5 Minutes</option>-->
                <!--        </select>-->

                <!--        <button type="submit" class="submit-btn" style="margin-top: 10px;">Start Trade</button>-->
                <!--    </form>-->
                <!--</div>-->
                
                <div class="trade-dashboard text-xs" style="margin-top:12px;">
                    <form action="assets/php/process_trade_v2.php" method="post" >
                    <div class="flex space-x-4 mb-4">
                          <!-- Select Type Dropdown -->
                          <select class="bg-black text-white text-base px-4 py-3 border border-gray-800 rounded w-full outline-none" id="stock" name="stock">
                            <option value="" disabled selected>Select Type</option>
                            <option value="forex">Forex</option>
                            <option value="crypto">Cryptocurrency</option>
                            <option value="stocks">Stocks</option>
                          </select>
                        
                          <!-- Currency Pair Input -->
                          <input type="text" placeholder="BTC/ETH" class="bg-black text-white text-base px-4 py-3 border border-gray-800 rounded w-full outline-none" id="trade_pair" name="trade_pair" required/>
                        
                          <!-- Lot Size Input -->
                          <input type="number" placeholder="Lot Size" class="bg-black text-white text-base px-4 py-3 border border-gray-800 rounded w-full outline-none" id="lot_size" name="lot_size" required/>
                        </div>

                      <!-- Chart Area -->
                        <div class="rounded p-4 mb-4">
                          <div class="h-[300px]">
                            <!-- TradingView Widget BEGIN -->
                            <div class="tradingview-widget-container h-full w-full">
                              <div class="tradingview-widget-container__widget h-full w-full"></div>
                              <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js" async>
                              {
                                "autosize": true,
                                "symbol": "FX:GBPUSD",
                                "interval": "5",
                                "timezone": "Etc/UTC",
                                "theme": "dark",
                                "style": "2",
                                "locale": "en",
                                "allow_symbol_change": true,
                                "support_host": "https://www.tradingview.com"
                              }
                              </script>
                            </div>
                            <!-- TradingView Widget END -->
                          </div>
                        </div>

                    
                      <!-- Entry Input Fields -->
                      <div class="flex space-x-4 mb-4">
                        <input type="number" placeholder="Entry Price" class="bg-black text-white text-base px-4 py-3 border border-gray-800 rounded w-full outline-none" id="entry_price" name="entry_price" required/>
                        <input type="number" placeholder="Stop Loss" class="bg-black text-white text-base px-4 py-3 border border-gray-800 rounded w-full outline-none" id="stop_loss" name="stop_loss" required/>
                        <input type="number" placeholder="Take Profit" class="bg-black text-white text-base px-4 py-3 border border-gray-800 rounded w-full outline-none" id="take_profit" name="take_profit" required/>
                      </div>
                    
                      <!-- Buy/Sell Buttons -->
                      <div class="flex space-x-4 mb-4">
                        <button type="submit" name="trading_action" value="BUY" class="bg-green-600 hover:bg-green-700 w-full py-3 rounded text-lg font-bold">BUY</button>
                        <button type="submit" name="trading_action" value="SELL" class="bg-red-600 hover:bg-red-700 w-full py-3 rounded text-lg font-bold">SELL</button>
                      </div>
                      <input type="text" id="user_id" name="user_id" value="<?= $user['id'] ?>" class="bg-black text-white" hidden />
                      <input type="text" id="user_id" name="user_signal_strength" value="<?= $user['signal_strength'] ?>" class="bg-black text-white" hidden />
                    </form>
                    
                      <!-- Session Info -->
                      <!--<div class="bg-[#141414] p-4 rounded">-->
                      <!--  <div class="grid grid-cols-2 gap-y-2 mb-4">-->
                      <!--    <div>Trading Type</div><div class="text-right">CRYPTOCURRENCY</div>-->
                      <!--    <div>Currency Pair</div><div class="text-right">BTC/USD</div>-->
                      <!--    <div>Entry Price</div><div class="text-right">109</div>-->
                      <!--    <div>Stop Loss</div><div class="text-right">27</div>-->
                      <!--    <div>Take Profit</div><div class="text-right">27</div>-->
                      <!--    <div>Status</div><div class="text-right text-red-500">SELL</div>-->
                      <!--  </div>-->
                      <!--  <button class="bg-red-600 hover:bg-red-700 w-full py-3 rounded text-lg font-bold">END SESSION</button>-->
                      <!--</div>-->
                      
                      <!-- Live Sessions Output -->
                        <?php if (count($sessions) > 0): ?>
                          <?php foreach ($sessions as $session): ?>
                            <div class="bg-[#141414] p-4 rounded mb-4">
                              <div class="grid grid-cols-2 gap-y-2 mb-4 text-sm">
                                <div>Trading Type</div><div class="text-right"><?= htmlspecialchars($session['stock']) ?></div>
                                <div>Currency Pair</div><div class="text-right"><?= htmlspecialchars($session['trade_pair']) ?></div>
                                <div>Entry Price</div><div class="text-right"><?= htmlspecialchars($session['entry_price']) ?></div>
                                <div>Stop Loss</div><div class="text-right"><?= htmlspecialchars($session['stop_loss']) ?></div>
                                <div>Take Profit</div><div class="text-right"><?= htmlspecialchars($session['take_profit']) ?></div>
                                <div>Status</div><div class="text-right text-red-500"><?= strtoupper(htmlspecialchars($session['trading_action'])) ?></div>
                              </div>
                              <form action="assets/php/end_session.php" method="POST">
                                <input type="hidden" name="id" value="<?= $session['id'] ?>">
                                <button type="submit" class="bg-red-600 hover:bg-red-700 w-full py-3 rounded text-lg font-bold">
                                  END SESSION
                                </button>
                              </form>
                            </div>
                          <?php endforeach; ?>
                        <?php else: ?>
                          <div class="text-gray-400 text-center">No live sessions found.</div>
                        <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal -->
    <div class="modal fade" id="tradeModal" tabindex="-1" role="dialog" aria-labelledby="tradeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Trade in Progress</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <p><strong>Stock:</strong> <span id="modal-stock"></span></p>
                    <p><strong>Trade Type:</strong> <span id="modal-trade-type"></span></p>
                    <p><strong>Amount:</strong> $<span id="modal-amount"></span></p>
                    <p><strong>Duration:</strong> <span id="modal-duration"></span> Seconds</p>
                    <p>Trade will complete in:</p>
                    <h3 id="countdown">...</h3>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/sidebar.js"></script>
    <script src="assets/js/dashboard.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.8/umd/popper.min.js" integrity="sha512-TPh2Oxlg1zp+kz3nFA0C5vVC6leG/6mm1z9+mA81MI5eaUVqasPLO8Cuk4gMF4gUfP5etR73rgU/8PNMsSesoQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.min.js" integrity="sha512-7rusk8kGPFynZWu26OKbTeI+QPoYchtxsmPeBqkHIEXJxeun4yJ4ISYe7C6sz9wdxeE1Gk3VxsIWgCZTc+vX3g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- JavaScript -->
    <script>
        document.addEventListener("DOMContentLoaded", handleURLMessage);

        // Handle message from URL and display it using SweetAlert
        function handleURLMessage() {
            const urlParams = new URLSearchParams(window.location.search);
            const message = urlParams.get('message');
            const messageType = urlParams.get('message_type');

            if (message) {
                const iconType = messageType === "success" ? "success" : "error"; // Define icon based on type

                swal.fire({
                    title: iconType === "success" ? "Success!" : "Error!",
                    text: decodeURIComponent(message),
                    icon: iconType,
                    confirmButtonText: "OK"
                });

                // Remove message from URL after displaying
                history.replaceState(null, '', window.location.pathname);
            }
        }

        $(document).ready(function() {
            $("#trade-form").submit(function(event) {
                event.preventDefault();

                let stock = $("#stock").val();
                let tradeType = $("#trade-type").val();
                let amount = parseFloat($("#amount").val());
                let duration = parseInt($("#duration").val());
                let balance = <?= $user['balance'] ?>;
                let trade_progress = <?= $user['trade_progress'] ?>;
                let user_id = <?= $user['id'] ?>

                // Validate amount
                if (!amount || amount <= 0) {
                    Swal.fire("Error", "Please enter a valid amount.", "error");
                    return;
                }

                // Check if user has enough balance
                if (amount > balance) {
                    Swal.fire("Error", "Insufficient balance!", "error");
                    return;
                }

                // Calculate trade result (Higher `trade_progress` means higher chance of winning)
                let winChance = Math.min(trade_progress / 100, 1.0); // Convert to percentage, max 90%
                let result = Math.random() < winChance ? "Profit" : "Loss";
                let profit = result === "Profit" ? amount * 1.2 : -amount; // Example profit/loss calculation

                // Send trade data to PHP backend (store result before timer starts)
                $.ajax({
                    url: "assets/php/process_trade.php",
                    type: "POST",
                    data: {
                        stock: stock,
                        tradeType: tradeType,
                        amount: amount,
                        duration: duration,
                        result: result,
                        profit: profit,
                        user_id: user_id
                    },
                    success: function(response) {
                        console.log(response);
                        let res = JSON.parse(response);
                        if (res.status === "success") {
                            // Update modal with user input
                            $("#modal-stock").text(stock);
                            $("#modal-trade-type").text(tradeType);
                            $("#modal-amount").text(amount);
                            $("#modal-duration").text(duration);

                            // Show trade modal
                            $("#tradeModal").modal("show");

                            // Start countdown before revealing the result
                            let countdownTime = duration;
                            let countdown = setInterval(function() {
                                if (countdownTime <= 0) {
                                    clearInterval(countdown);
                                    $("#countdown").text("Trade Completed!");

                                    // Reveal stored trade result
                                    setTimeout(function() {
                                        Swal.fire("Trade Result", "You got a " + result + "!", result === "Profit" ? "success" : "error");
                                        $("#tradeModal").modal("hide");
                                    }, 1000);
                                } else {
                                    $("#countdown").text(countdownTime + "s");
                                }
                                countdownTime--;
                            }, 1000);
                        } else {
                            Swal.fire("Error", res.message, "error");
                        }
                    },
                    error: function() {
                        Swal.fire("Error", "Something went wrong!", "error");
                    }
                });
            });
        });

    </script>
    
    

</body>

</html>